/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.currency;

import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.currency.CurrencyResolver;
import com.nyfaria.numismaticoverhaul.item.CurrencyItem;
import com.nyfaria.numismaticoverhaul.item.MoneyBagItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CurrencyHelper {
    public static long getMoneyInInventory(Player player, boolean remove) {
        long value = 0L;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            Item item;
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (CurrencyHelper.isCombined(stack) || !((item = stack.m_41720_()) instanceof CurrencyItem)) continue;
            CurrencyItem currencyItem = (CurrencyItem)item;
            value += currencyItem.getValue(stack);
            if (!remove) continue;
            player.m_150109_().m_36057_(stack);
        }
        return value;
    }

    public static int getValue(List<ItemStack> stacks) {
        return stacks.stream().mapToInt(stack -> {
            if (stack == null) {
                return 0;
            }
            if (CurrencyHelper.isCombined(stack)) {
                return 0;
            }
            Item patt1572$temp = stack.m_41720_();
            if (!(patt1572$temp instanceof CurrencyItem)) {
                return 0;
            }
            CurrencyItem currencyItem = (CurrencyItem)patt1572$temp;
            return (int)currencyItem.getValue((ItemStack)stack);
        }).sum();
    }

    public static void offerAsCoins(Player player, long value) {
        for (ItemStack itemStack : CurrencyConverter.getAsValidStacks(value)) {
            player.m_150109_().m_150079_(itemStack);
        }
    }

    public static boolean deduceFromInventory(Player player, long value) {
        long presentInInventory = CurrencyHelper.getMoneyInInventory(player, false);
        if (presentInInventory < value) {
            return false;
        }
        CurrencyHelper.getMoneyInInventory(player, true);
        CurrencyHelper.offerAsCoins(player, presentInInventory - value);
        return true;
    }

    public static List<ItemStack> getAsStacks(long value, int maxStacks) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        List<ItemStack> rawStacks = CurrencyConverter.getAsValidStacks(value);
        if (rawStacks.size() <= maxStacks) {
            stacks.addAll(rawStacks);
        } else {
            stacks.add(MoneyBagItem.create(value));
        }
        return stacks;
    }

    public static ItemStack getClosest(long value) {
        long[] values = CurrencyResolver.splitValues(value);
        for (int i = 0; i < 2 && values[i + 1] != 0L; ++i) {
            int n = i + 1;
            values[n] = values[n] + (long)Math.round((float)values[i] / 100.0f);
            values[i] = 0L;
        }
        return CurrencyConverter.getAsItemStackList(CurrencyResolver.combineValues(values)).get(0);
    }

    public static long[] getFromNbt(CompoundTag nbt, String key) {
        if (nbt.m_128425_(key, 12)) {
            return nbt.m_128467_(key);
        }
        if (!nbt.m_128425_(key, 11)) {
            return new long[0];
        }
        int[] intArray = nbt.m_128465_(key);
        long[] longArray = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }

    private static boolean isCombined(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("Combined", 1);
    }
}

